﻿namespace Hims.Api.Models.Appointment
{
    using Hims.Shared.EntityModels;
    using Microsoft.AspNetCore.Http;
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The book appointment request.
    /// </summary>
    public class BookAppointmentRequest
    {

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the follow up for appointment.
        /// </summary>
        public int? FollowUpForAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the follow up for admission.
        /// </summary>
        public int? FollowUpForAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the visit type.
        /// </summary>
        public char? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the charge type.
        /// </summary>
        public char? ChargeType { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public string AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the appointment end time.
        /// </summary>
        public string? AppointmentEndTime { get; set; }

        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int? CouponId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal Amount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public decimal Discount { get; set; }

        /// <summary>
        /// Gets or sets the provider charges.
        /// </summary>
        public decimal ProviderCharges { get; set; }

        /// <summary>
        /// Gets or sets the app charges.
        /// </summary>
        public decimal AppCharges { get; set; }

        /// <summary>
        /// Gets or sets the wallet amount.
        /// </summary>
        public decimal? WalletAmount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal Total { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal? TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        ///  Gets or sets symptoms.
        /// </summary>
        public string Symptoms { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool PaymentStatus { get; set; }

        /// <summary>
        ///  Gets or sets payment type.
        /// </summary>
        public string PaymentType { get; set; }

        /// <summary>
        ///  Gets or sets payment number.
        /// </summary>
        public string PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// gets or sets the specializationId.
        /// </summary>
        public int SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the log from.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int? ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the location id.
        /// </summary>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the appointment type id from appointmentType masters.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? AppointmentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the Pay type id from payType masters.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the token number.
        /// </summary>
        /// <value>
        /// The token number.
        /// </value>
        public int? TokenNumber { get; set; }

        /// <summary>
        ///  Gets or sets payment gateway.
        /// </summary>
        public string PaymentGateway { get; set; }

        /// <summary>
        /// Gets or sets the patient reg amount.
        /// </summary>
        public decimal? PatientRegistrationAmount { get; set; }

        /// <summary>
        /// Gets or sets the registration charges. 
        /// this value is used to add in Patient table (while inserting new patient either identify or unidentify patient.)
        /// </summary>
        public decimal? Charges { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        public string Transaction { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string SalucroTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the is salucro appointment.
        /// </summary>
        public bool IsSalucroAppointment { get; set; }

        /// <summary>
        /// Gets or sets the provider availability charge type id.
        /// </summary>
        public int? DoctorSpecializationChargeModuleDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the other remarks.
        /// </summary>
        /// <value>
        /// The other remarks.
        /// </value>
        public string OtherRemarks { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? AuthorityId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? ReasonId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public string Remarks { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? ModuleType { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public string TypeOfPayment { get; set; }

        /// <summary>
        /// Gets or sets the appointment discount in percentage.
        /// </summary>
        public decimal? DiscountInPercentage { get; set; }

        /// <summary>
        /// Gets or sets the appointment total.
        /// </summary>
        public decimal AfterDiscount { get; set; }

        /// <summary>
        /// Gets or sets the patient discount in percentage.
        /// </summary>
        public decimal PatientDiscountInPercentage { get; set; }

        /// <summary>
        /// Gets or sets the patient discount in rupees.
        /// </summary>
        public decimal PatientDiscountInRupees { get; set; }

        /// <summary>
        /// Gets or sets the patient total.
        /// </summary>
        public decimal PatientTotal { get; set; }
        /// <summary>
        /// Gets or sets the appointment total.
        /// </summary>
        public bool? IsHealthCard { get; set; }


        /// <summary>
        /// Gets or sets the session id.
        /// </summary>
        public int? SessionId { get; set; }
    }

    /// <summary>
    /// The quick schedule request.
    /// </summary>
    public class QuickScheduleRequest
    {
        /// <summary>
        /// Gets or sets the login id.
        /// </summary>
        public int? LoginLocationId { get; set; }
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the provider location id.
        /// </summary>
        public int? ProviderLocationId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ProviderAvailabilityId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability charge type id.
        /// </summary>
        public int? DoctorSpecializationChargeModuleDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the provider availability id.
        /// </summary>
        public int ConsultationTypeId { get; set; }

        /// <summary>
        /// Gets or sets the appointment end time.
        /// </summary>
        public string? AppointmentEndTime { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the follow up for appointment.
        /// </summary>
        public int? FollowUpForAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the follow up for admission.
        /// </summary>
        public int? FollowUpForAdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the HWC patient identifier.
        /// </summary>
        /// <value>
        /// The HWC patient identifier.
        /// </value>
        public int? HWCPatientId { get; set; }

        /// <summary>
        /// Gets or sets the id proof identifier.
        /// </summary>
        /// <value>
        /// The id proof identifier.
        /// </value>
        public int? IdProofId { get; set; }

        /// <summary>
        /// Gets or sets the id proof value.
        /// </summary>
        public string? IdProofValue { get; set; }

        /// <summary>
        /// Gets or sets the visit type.
        /// </summary>
        public char? VisitType { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the charge type.
        /// </summary>
        public char? ChargeType { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public string AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int? CouponId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal Amount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public decimal Discount { get; set; }

        /// <summary>
        /// Gets or sets the wallet amount.
        /// </summary>
        public decimal? WalletAmount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal Total { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal? TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        ///  Gets or sets symptoms.
        /// </summary>
        //public string Symptoms { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool PaymentStatus { get; set; }

        ///// <summary>
        /////  Gets or sets payment type.
        ///// </summary>
        //public string PaymentType { get; set; } /// PayTypeId added.

        /// <summary>
        ///  Gets or sets payment number.
        /// </summary>
        public string PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the specialization Id.
        /// </summary>
        public int SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the log from.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the first name.
        /// </summary>
        public string FirstName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the middle name.
        /// </summary>
        public string MiddleName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the last name.
        /// </summary>
        public string LastName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string FullName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the father or husband.
        /// </summary>
        public string FatherOrHusband { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the salutation.
        /// </summary>
        public string Salutation { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the aadhar no.
        /// </summary>
        public string AadharNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public short? Age { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public char? Gender { get; set; }

        /// <summary>
        /// Gets or sets the umr.
        /// </summary>
        public string UMRNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country id.
        /// </summary>
        public int? CountryId { get; set; }

        /// <summary>
        /// Gets or sets the profile image url.
        /// </summary>
        public string ProfileImageUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string ThumbnailUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the base 64 profile image.
        /// </summary>
        public string Base64ProfileImage { get; set; }

        /// <summary>
        /// Gets or sets the street address.
        /// </summary>
        public string StreetAddress { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the address line 2.
        /// </summary>
        public string AddressLine2 { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the city.
        /// </summary>
        public string City { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the state.
        /// </summary>
        public string State { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Zipcode.
        /// </summary>
        public string Zipcode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country name.
        /// </summary>
        public string CountryName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the country code.
        /// </summary>
        public string CountryCode { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the Referred by.
        /// </summary>
        public string ReferredBy { get; set; }

        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string ReferredByName { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the charge types id.
        /// </summary>
        public int? ChargeTypesId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is unidentified.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is unidentified; otherwise, <c>false</c>.
        /// </value>
        public bool IsUnidentified { get; set; }
        /// <summary>
        /// Gets or sets the appointment type id from appointmentType masters.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? AppointmentTypeId { get; set; }

        /// <summary>
        /// Gets or sets the education.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public string Education { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string Occupation { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public char? MaritalStatus { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string? Religion { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string Nationality { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string RelationName { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string RelativeMobile { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string RelativeOccupation { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string RealtiveEducation { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string RelativeDateOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public char? RelativeGender { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public string Relation { get; set; }
        /// <summary>
        /// Gets or sets the Referred by name.
        /// </summary>
        public int? PatientReferredById { get; set; }

        /// <summary>
        /// Gets or sets the Pay type id from payType masters.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the token number.
        /// </summary>
        /// <value>
        /// The token number.
        /// </value>
        public int TokenNumber { get; set; }

        /// <summary>saw
        /// Gets or sets the Blood group
        /// </summary>
        public string? BloodGroup { get; set; }

        /// <summary>
        /// Gets or sets the emergency contacts.
        /// </summary>
        public List<PatientEmergencyModel>? EmergencyContacts { get; set; }

        /// <summary>
        /// Gets or sets the insurances.
        /// </summary>
        public List<PatientInsuranceModel>? Insurances { get; set; }

        /// <summary>
        /// Gets or sets the relative details.
        /// </summary>
        public List<PatientFamilyModel>? RelativeDetails { get; set; }

        /// <summary>
        /// Gets or sets the registration charges. 
        /// this value is used to add in Patient table (while inserting new patient either identify or unidentify patient.)
        /// </summary>
        public decimal? Charges { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? HowDidYouKnowId { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? EducationId { get; set; }

        /// <summary>
        /// Gets or sets the id proof id identifier.
        /// </summary>
        /// <value>
        /// The id proof id identifier.
        /// </value>
        public int? OccupationId { get; set; }
        /// <summary>saw
        /// Gets or sets the Blood group
        /// </summary>
        public string? BirthMark1 { get; set; }
        /// <summary>saw
        /// Gets or sets the Blood group
        /// </summary>
        public string? BirthMark2 { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        public string Transaction { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public int? SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        public string SalucroTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the is salucro appointment.
        /// </summary>
        public bool IsSalucroAppointment { get; set; }

        /// <summary>
        /// Gets or sets the type of the relation.
        /// </summary>
        /// <value>
        /// The type of the relation.
        /// </value>
        public string RelationType { get; set; }

        /// <summary>
        /// Gets or sets the occupation detail.
        /// </summary>
        /// <value>
        /// The occupation detail.
        /// </value>
        public string OccupationDetail { get; set; }

        /// <summary>
        /// Gets or sets the is new patient.
        /// </summary>
        /// <value>
        /// The is new patient.
        /// </value>
        public bool IsNewPatient { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool? SaveRelativeAsPatient { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? InsuranceId { get; set; }

        /// <summary>
        /// Gets or sets the other remarks.
        /// </summary>
        /// <value>
        /// The other remarks.
        /// </value>
        public string OtherRemarks { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? AuthorityId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? ReasonId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public string Remarks { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public string DocumentName { get; set; }

        public IFormFileCollection Files { get; set; } = null;

        /// <summary>
        /// Gets or sets the document type.
        /// </summary>
        public string DocumentType { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        public List<String> FilePaths { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public string Relative { get; set; }

        /// <summary>
        ///  Gets or sets payment status.
        /// </summary>
        public bool? UpdatePatient { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public int? ReferredByNameId { get; set; }

        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public string TypeOfPayment { get; set; }

        /// <summary>
        /// Gets or sets the is emergency.
        /// </summary>
        public bool IsEmergency { get; set; }

        /// <summary>
        /// Gets or sets the patient discount in percentage.
        /// </summary>
        public decimal PatientDiscountInPercentage { get; set; }

        /// <summary>
        /// Gets or sets the patient discount in rupees.
        /// </summary>
        public decimal PatientDiscountInRupees { get; set; }

        /// <summary>
        /// Gets or sets the patient total.
        /// </summary>
        public decimal PatientTotal { get; set; }

        /// <summary>
        /// Gets or sets the appointment discount in percentage.
        /// </summary>
        public decimal? AppointmentDiscountInPercentage { get; set; }

        /// <summary>
        /// Gets or sets the appointment discount in rupees.
        /// </summary>
        public decimal AppointmentDiscountInRupees { get; set; }

        /// <summary>
        /// Gets or sets the appointment total.
        /// </summary>
        public decimal AppointmentTotal { get; set; }

        /// <summary>
        /// Gets or sets the appointment total.
        /// </summary>
        public decimal AfterDiscount { get; set; }
        /// <summary>
        /// Gets or sets the IsHealthCard.
        /// </summary>
        public bool? IsHealthCard { get; set; }
        /// <summary>
        /// Gets or sets the IsHealthCard.
        /// </summary>
        public string Details { get; set; }

        /// <summary>
        /// Gets or sets the session id.
        /// </summary>
        public int? SessionId { get; set; }

    }

}

